<?php
require_once 'config.php';
require_once 'splash_config.php';
require_once 'security.php';

// Check if user is logged in
$isLoggedIn = isset($_SESSION['user_id']);
$userData = $isLoggedIn ? $_SESSION['user_data'] : null;

// Check for suspended account
$isSuspended = $isLoggedIn && isset($userData['status']) && $userData['status'] === 'suspended';
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;700&family=Roboto+Mono:wght@700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <!-- SPLASH SCREEN START -->
    <div id="splash-screen">
        <div class="splash-loader"></div>
        <div class="splash-image-container">
            <img src="<?php echo SPLASH_IMAGE_URL; ?>" alt="Welcome">
        </div>
    </div>
    <!-- SPLASH SCREEN END -->

    <?php if ($isLoggedIn): ?>
    <div class="container" style="display: none;">
        <!-- Main application content -->
        <?php include 'components/header.php'; ?>
        
        <div class="notice-bar">
            <div class="notice-content" id="notice-content">
                <!-- Notice will be loaded via JavaScript -->
            </div>
        </div>

        <?php include 'components/navigation.php'; ?>
        
        <div id="home-page" class="page-content active">
            <?php include 'components/game.php'; ?>
            <?php include 'components/history.php'; ?>
        </div>
        
        <?php include 'pages/wallet.php'; ?>
        <?php include 'pages/profile.php'; ?>
        <?php include 'pages/deposit.php'; ?>
        <?php include 'pages/withdraw.php'; ?>
        <?php include 'pages/referral.php'; ?>
        <?php include 'pages/bonus.php'; ?>
        <?php include 'pages/settings.php'; ?>
        
    </div>
    <?php else: ?>
    <div class="auth-container" id="auth-container">
        <?php include 'components/auth.php'; ?>
    </div>
    <?php endif; ?>

    <!-- Popups -->
    <?php include 'components/popups.php'; ?>
    
    <!-- Floating Support Button -->
    <a id="support-link" href="#" target="_blank" class="floating-support-btn">
        <i class="fas fa-headset"></i>
    </a>

    <!-- Firebase SDK -->
    <script src="https://www.gstatic.com/firebasejs/9.15.0/firebase-app-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.15.0/firebase-auth-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.15.0/firebase-database-compat.js"></script>

    <script>
        // Firebase Configuration from PHP
        const firebaseConfig = <?php echo json_encode(FIREBASE_CONFIG); ?>;
        
        // App Constants
        const SPLASH_DURATION = <?php echo SPLASH_DURATION; ?>;
        const IS_SUSPENDED = <?php echo $isSuspended ? 'true' : 'false'; ?>;
        const IS_LOGGED_IN = <?php echo $isLoggedIn ? 'true' : 'false'; ?>;
        const CSRF_TOKEN = '<?php echo Security::generateCSRFToken(); ?>';
        
        // Splash Screen Logic
        window.addEventListener('load', () => {
            setTimeout(() => {
                const splash = document.getElementById('splash-screen');
                splash.classList.add('hidden');
                setTimeout(() => {
                    splash.style.display = 'none';
                    <?php if ($isLoggedIn): ?>
                    document.querySelector('.container').style.display = 'flex';
                    <?php endif; ?>
                }, 500);
            }, SPLASH_DURATION);
        });
        
        <?php if ($isSuspended): ?>
        // Disable all interactions if suspended
        document.addEventListener('DOMContentLoaded', function() {
            alert('আপনার অ্যাকাউন্টটি সাসপেন্ড করা হয়েছে। দয়া করে সাপোর্টে যোগাযোগ করুন।');
            // Disable all buttons and forms
            document.querySelectorAll('button, input, .btn').forEach(el => {
                el.disabled = true;
                el.style.opacity = '0.5';
            });
        });
        <?php endif; ?>
    </script>
    
    <script src="js/app.js"></script>
    <script src="js/game.js"></script>
    <script src="js/wallet.js"></script>
    <script src="js/auth.js"></script>
</body>
</html>